*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Dicrotophos                                          *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";
libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data dicrotophos;
     set epa.dicrotophos;
run;
proc sort data=dicrotophos;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Dicrotophos - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Dicrotophos);
ods rtf close;




*===> Human vs. Rat;

title "model 2b: a model with same random effects of a and b for both species";
*ods select ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=dicrotophos tech=newrap method=firo lis=3 maxiter=1000;
      PARMS ha=0.5647
			hb=1.1189	
			ra=0.6030
			rb=1.0041	
			ga=0.2158	
			gab=0.4840	
			gb=.1482
			S2E=0.2435;

            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-4 + H_I__M + rrb*Rat*1e-4 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  ua ub ~ normal([0, 0],  [ga*1e-1, gab*1e-1, gb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Dicrotophos human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=Dicrotophos, model=2)
ods rtf close;
%Calculate_Ki(chemical=Dicrotophos, Hadj=1e-4, Radj=1e-4);



*===> Adult vs. Infant;

title "Model 2: adult vs. infant";
*ods select ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=dicrotophos(where=(Human=1)) tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=0.5486	adB=1.0699
			ia=.5383 iB=1.0044
			gha=0.01551 	ghab=0.02951	ghb=0.07225
			S2E=0.02000;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-4 + H_I__M*adult + rib*1e-4*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-2);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
 		predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Dicrotophos Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=Dicrotophos, model=2)
ods rtf close;


*===> Male vs. Female;

title "Model 2: male vs. female";
*ods select ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=dicrotophos(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.5078 mb= 1.0641
			fa=.5751 fB=1.0417
			gha=.1361 	ghab=0.2913	ghb=0.7581
			S2E=.1970;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
 			PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-4 + H_I__M*male + rfb*female*1e-4 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-1]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Dicrotophos Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=Dicrotophos, model=2)
ods rtf close;


*===> Caucasian vs. Other Races;

title "Final model 2 - Caucasian vs. Other Race";
*ods select ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=dicrotophos(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=.5563	cB=11.1393
			ora=.5248 orB=9.2183
			gha=.1552	ghab=2.79	ghb=6.341
			S2E=.1998;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb]) SUBJECT=ID out=RandID_CO;
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
		predict pred out=Resid_CO;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Dicrotophos Caucasian-Other Races.rtf" startpage=no;
%DiagnosticsCO(chemical=Dicrotophos, model=2)
ods rtf close;
